﻿using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public class PatientDB : DBUtils
    {
        public IEnumerable<PatientSearchResult> SearchPatients(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            List<PatientSearchResult> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_PatientSearch(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_ICN,
                            PATIENT_SSN,
                            PATIENT_LAST_NAME,
                            PATIENT_FIRST_NAME,
                            SORT_COLUMN,
                            START_ROW,
                            MAX_ROWS)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public int SearchPatientsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_PatientSearchCount(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_ICN,
                            PATIENT_SSN,
                            PATIENT_LAST_NAME,
                            PATIENT_FIRST_NAME,
                            ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }

        public IEnumerable<PatientSearchResult> SearchAllPatients(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            List<PatientSearchResult> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_PatientSearchAll(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_ICN,
                            PATIENT_SSN,
                            PATIENT_LAST_NAME,
                            PATIENT_FIRST_NAME,
                            SORT_COLUMN,
                            START_ROW,
                            MAX_ROWS)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public int SearchAllPatientsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_ICN,
            string PATIENT_SSN,
            string PATIENT_LAST_NAME,
            string PATIENT_FIRST_NAME)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_PatientSearchAllCount(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_ICN,
                            PATIENT_SSN,
                            PATIENT_LAST_NAME,
                            PATIENT_FIRST_NAME,
                            ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }
    }
}
